<?php

declare(strict_types=1);

namespace AlloCine\UnifiedTag\Tests\Bundle\Icu;

use AlloCine\UnifiedTag\Bundle\Icu\IcuCompatibility;
use PHPUnit\Framework\TestCase;

final class IcuCompatibilityTest extends TestCase
{
    public function testGenderConversion(): void
    {
        $input = '{0}Réalisateur|{1}Réalisatrice';
        $expected = '{gender, select, male {Réalisateur} female {Réalisatrice}}';

        $this->assertSame ($expected, IcuCompatibility::genderConversion($input), 'Incorrect ICU gender conversion');
    }
}
