<?php

declare(strict_types=1);

use AlloCine\I18NBundle\Translation\Loco;
use AlloCine\UnifiedTag\Bundle\Worker\TranslationWorker;
use Symfony\Component\HttpFoundation\File\File;

define('API_KEY', 'p_Zvs_gZuY5P4wuEooAssIuGIslebk5zs');
require __DIR__ . '/vendor/autoload.php';

/** script to import trads from Loco to local definitions (export from Loco) */

$client = new Loco(API_KEY);

$tags = $client->getTags();
$locales = $client->getLocales();
$path = TranslationWorker::OUTPUT_PATH;
print_r("starting to export trads...\n");

foreach ($locales as $locale => $realLocale) {
    foreach ($tags as $tag) {
        $export = $client->export($realLocale, $tag);
        try {
            $file = new File(sprintf('%s/%s.%s.xlf', $path, $tag, $locale));
        } catch (Exception) {
            try {
                $file = new File(sprintf('%s/%s.%s.xlf', $path, $tag, $realLocale));
            } catch (Exception) {
                printf("{$file->getFilename()} does not exists yet\n");
            }
        }
        print_r("exporting {$file->getFilename()}...\n");

        $file->openFile('w')->fwrite($export);
    }
}
