PHP_CLI = docker run --rm \
	-u $$(id -u):$$(id -g) \
	-v "$$(pwd):/src" \
	-v "$$COMPOSER_HOME:/tmp/.composer" \
	-e COMPOSER_HOME=/tmp/.composer \
	-e COMPOSER_PROCESS_TIMEOUT=$$COMPOSER_PROCESS_TIMEOUT \
	-w /src \
	eu.gcr.io/ac-registry/php${PHP_VERSION}-node16:cli
BUILDDIR = build

.PHONY: login-gcp
login-gcp:
	docker login -u oauth2accesstoken -p "$$(gcloud auth print-access-token)" https://eu.gcr.io

.PHONY: prepare
prepare:
	mkdir -p $(BUILDDIR)/logs/coverage $(BUILDDIR)/docs
	-rm composer.lock
	$(PHP_CLI) php -v
	$(PHP_CLI) composer install -n --no-progress

.PHONY: phpunit
phpunit:
	$(PHP_CLI) vendor/phpunit/phpunit/phpunit --log-junit $(BUILDDIR)/logs/phpunit.xml

.PHONY: clean
clean:
	-rm -rf $(BUILDDIR)
	-rm composer.lock
