## —— Cloudbuild ———————————————————————————————————————————————————————————————————

# Parameters expected
# standard includes :
# - GCLOUD_PREFIX
# from .gitlab-ci.yml otherwise Makefile otherwise env:
# common :
# - GCP_PROJECT
# - IMPERSONATE
# - PRIMARY_LOCATION
# cloudbuild :
# - CLOUDBUILD_BUCKET
# - DOCKERFILE
# - IMAGE_TAG
# - URI_IMAGE_DOCKER
# - (Optional): SUBSTITUTIONS_ADDON
# assets :
# - ASSETS_BUCKET
# - ASSETS_BUILD_PATH

GCLOUD_BUILD=${GCLOUD_PREFIX} gcloud builds submit ${IMPERSONATE} \
	--region=${PRIMARY_LOCATION} \
	--service-account=projects/${GCP_PROJECT}/serviceAccounts/sa-deployer@${GCP_PROJECT}.iam.gserviceaccount.com \
	--gcs-source-staging-dir=gs://${CLOUDBUILD_BUCKET}/source \
	--gcs-log-dir=gs://${CLOUDBUILD_BUCKET}/logs

SUBSTITUTIONS_ADDON?=

SUBSTITUTIONS=_URI_IMAGE_DOCKER=${URI_IMAGE_DOCKER},_IMAGE_TAG=${IMAGE_TAG},_DOCKERFILE=${DOCKERFILE}${SUBSTITUTIONS_ADDON}

SUBSTITUTIONS_WITH_ASSETS=${SUBSTITUTIONS},_ASSETS_BUILD_PATH=${ASSETS_BUILD_PATH},_ASSETS_BUCKET=${ASSETS_BUCKET}

.PHONY: cloud_build
cloud_build: gcloud_init ## build docker image and push in artifact registry
	${GCLOUD_BUILD} --substitutions ${SUBSTITUTIONS} --config cloudbuild/main.yaml .

.PHONY: cloud_build_with_assets
cloud_build_with_assets: gcloud_init ## cloud_build + push assets builded on bucket
	${GCLOUD_BUILD} --substitutions ${SUBSTITUTIONS_WITH_ASSETS} --config cloudbuild/main_with_assets.yaml .
