<?php

namespace AlloCine\UnifiedTag\Bundle\Twig\Extension;

use AlloCine\UnifiedTag\Bundle\Exceptions\UnRecognisedTagException;
use AlloCine\UnifiedTag\Bundle\Worker\UnifiedTagWorker;
use Psr\Cache\InvalidArgumentException;
use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;

class UnifiedTagExtension extends AbstractExtension
{
    /**
     * @var UnifiedTagWorker
     */
    private $worker;

    public function __construct(UnifiedTagWorker $worker)
    {
        $this->worker = $worker;
    }

    public function getFilters(): array
    {
        return [
            new TwigFilter('ut_id_to_tag', [$this, 'UtIdToTag']),
            new TwigFilter('ut_id_to_tag3d', [$this, 'UtIdToTag3d']),
            new TwigFilter('ut_tag_to_id', [$this, 'UtTagToId']),
            new TwigFilter('ut_tag_to_tag3d', [$this, 'UtTagToTag3d']),
            new TwigFilter('ut_tag3d_to_id', [$this, 'UtTag3dToId']),
            new TwigFilter('ut_tag3d_to_tag', [$this, 'UtTag3dToTag']),
        ];
    }

    /**
     * @param int $id
     *
     * @return string
     * @throws UnRecognisedTagException|\Exception|InvalidArgumentException
     */
    public function UtIdToTag(int $id): string
    {
        return $this->worker->getTagGraphFromId($id);
    }

    /**
     * @param int $id
     *
     * @return string
     * @throws UnRecognisedTagException|\Exception|InvalidArgumentException
     */
    public function UtIdToTag3d(int $id): string
    {
        return $this->worker->getTag3dFromId($id);
    }

    /**
     * @param string $tag
     *
     * @return int
     * @throws UnRecognisedTagException|\Exception|InvalidArgumentException
     */
    public function UtTagToId(string $tag): int
    {
        return $this->worker->getIdFromTagGraph($tag);
    }

    /**
     * @param string $tag
     *
     * @return string
     * @throws UnRecognisedTagException|\Exception|InvalidArgumentException
     */
    public function UtTagToTag3d(?string $tag): string
    {
        if (empty($tag)) {
            return '';
        }

        return $this->worker->getTag3dFromTagGraph($tag);
    }

    /**
     * @param string $tag3d
     *
     * @return int
     * @throws UnRecognisedTagException|\Exception|InvalidArgumentException
     */
    public function UtTag3dToId(string $tag3d): int
    {
        return $this->worker->getIdFromTag3d($tag3d);
    }

    /**
     * @param ?string $tag3d
     *
     * @return string
     * @throws UnRecognisedTagException|\Exception|InvalidArgumentException
     */
    public function UtTag3dToTag(?string $tag3d): string
    {
        if (empty($tag)) {
            return '';
        }

        return $this->worker->getTagGraphFromTag3d($tag3d);
    }
}
