<?php

namespace AlloCine\UnifiedTag\Tests\Bundle\Icu;

use AlloCine\UnifiedTag\Bundle\Icu\IcuCompatibility;
use PHPUnit\Framework\TestCase;

class IcuCompatibilityTest extends TestCase
{
    public function testGenderConversion()
    {
        $input = '{0}Réalisateur|{1}Réalisatrice';
        $expected = '{gender, select, male {Réalisateur} female {Réalisatrice}}';

        $this->assertSame ($expected, IcuCompatibility::genderConversion($input), 'Incorrect ICU gender conversion');
    }
}
