const path = require('path');
const tagBundle = require('../index');

describe('tag bundle', function() {
  beforeAll(() => {
    this.tagBundle = new tagBundle(tagBundle.TYPES.ACTIVITIES); // Fake type

    // mock fake file
    this.tagBundle.setFile(
      this.tagBundle.getFile(path.join(__dirname, 'mock.csv')),
    );
  });

  it('should be get a tag3d from activity id', () => {
    const tag3d = this.tagBundle.getTag3dFromId(15012);
    expect(tag3d).toBe('Company.Activity.FilmExhibitor');
  });

  it('should be get a tagGraph from activity id', () => {
    const tagGraph = this.tagBundle.getTagGraphFromId(15012);
    expect(tagGraph).toBe('FILM_EXHIBITOR');
  });

  it('should be get a id from activity id', () => {
    const id = this.tagBundle.getIdFromTag3d('Company.Activity.FilmExhibitor');
    expect(id).toBe(15012);
  });

  it('should be get a tagGraph from a tag 3d', () => {
    const tag3d = this.tagBundle.getTagGraphFromTag3d(
      'Company.Activity.FilmExhibitor',
    );
    expect(tag3d).toBe('FILM_EXHIBITOR');
  });

  it('should be get a id from tag graph', () => {
    const tag3d = this.tagBundle.getIdFromTagGraph('FILM_EXHIBITOR');
    expect(tag3d).toBe(15012);
  });

  it('should be get a tag 3d from tag graph', () => {
    const tag3d = this.tagBundle.getTag3dFromTagGraph('FILM_EXHIBITOR');
    expect(tag3d).toBe('Company.Activity.FilmExhibitor');
  });
});
