module.exports = {
	root: true,

	ignorePatterns: ['**/dist/*', '**/build/*'],

	parser: '@typescript-eslint/parser',
	parserOptions: {
		sourceType: 'module',
		ecmaVersion: 'latest',
	},

	env: {
		es6: true,
		node: true,
	},

	settings: {
		node: {
			version: 'detect',
		},
	},

	plugins: ['@typescript-eslint', 'prettier', 'import'],
	extends: [
		'eslint:recommended',
		'plugin:@typescript-eslint/recommended',
		'plugin:prettier/recommended',
		'plugin:import/typescript',
	],
	rules: {
		'prefer-const': [
			'error',
			{
				'destructuring': 'any',
				'ignoreReadBeforeAssign': false,
			},
		],
		'object-shorthand': 'error',
		'@typescript-eslint/no-empty-function': 0,
		'@typescript-eslint/no-non-null-assertion': 0,
		'@typescript-eslint/consistent-type-imports': 'error',
		'sort-imports': [
			'error',
			{
				ignoreCase: false,
				ignoreDeclarationSort: true,
				ignoreMemberSort: false,
				memberSyntaxSortOrder: ['none', 'all', 'multiple', 'single'],
				allowSeparatedGroups: true,
			},
		],
		'import/no-unresolved': 'error',
		'import/no-named-as-default-member': 'off',
		'import/order': [
			'error',
			{
				groups: ['builtin', 'external', 'internal', ['sibling', 'parent'], 'index', 'unknown'],
				'newlines-between': 'always',
				alphabetize: {
					order: 'asc',
					caseInsensitive: true,
				},
			},
		],
	},
}
