<?php

namespace AlloCine\UnifiedTag\Tests\Bundle\Icu;

use AlloCine\UnifiedTag\Bundle\Icu\IcuCompatibility;
use PHPUnit\Framework\TestCase;

class IcuCompatibilityTest extends TestCase
{
    public function testGenderConversion()
    {
        $input = '{0}Acteur|{1}Actrice';
        $expected = '{gender, select, male {Acteur} female {Actrice}}';

        $this->assertSame ($expected, IcuCompatibility::genderConversion($input), 'Incorrect ICU gender conversion');
    }
}
