# Unified Tag Bundle

- If you are a PHP developer, how to install [bundle](doc/bundle-installation.md)
- If you are not a PHP developer, you just need to do in first `make login` and then `make prepare`.
- How to use [service](doc/bundle-usage.md)

## What can i do when I add a tag3D

- First add your tag in the csv
- Second get updated trads from loco : `make pull-update-trads`
- After export trads to loco : `make exports-trads-from-local-to-loco` or `make import-trads`
- End generate trads for mobile : `make convert-mobile`

## How to generate new translations from a new csv file

To generate new xlif files from a freshly created file inside the `src/Bundle/Resources` folder, use

`make update-trads`

## How to update trads

To update trads with news tags or to purge, just use the
command `make update-trads`, commit and push the changes in pull request

## How to generate mobile trads

Use command `make convert-mobile`, commit and push the changes in pull request

## How to import trads from loco

Use command `make import-trads-from-loco-to-local import-trads convert-mobile`,
commit and push the changes in a pull request

## How to export trads to loco

Use command `make exports-trads-from-local-to-loco`

## NodeJS version

You need to have node 22 installed on your machine. As this package only exports a library, there's limited interactions with it locally and the only thing you can do is run the tests

- test: `npm run test`

If it fails look if the diff is what you want and then update tests with `yarn test -u` command.

Then :

- commit changes
- create your merge request on Gitlab
- Change the version of the package on package.json file
- merge into master

### Deployment

After the merge has been done, create a new tag (using the Gitlab UI is preferable) and a pipeline will publish the new version to the GitLab package registry using the step `node:gitlab-registry`.
