<?php

namespace AlloCine\UnifiedTag\Bundle\Twig\Extension;

use AlloCine\UnifiedTag\Bundle\Exceptions\UnRecognisedTagException;
use AlloCine\UnifiedTag\Bundle\Worker\UnifiedTagWorker;

class UnifiedTagExtension extends \Twig_Extension
{
    /**
     * @var UnifiedTagWorker
     */
    private $worker;

    public function __construct(UnifiedTagWorker $worker)
    {
        $this->worker = $worker;
    }

    /**
     * {@inheritsDoc}
     */
    public function getFilters()
    {
        return [
            new \Twig_SimpleFilter('ut_id_to_tag', [$this, 'UtIdToTag']),
            new \Twig_SimpleFilter('ut_id_to_tag3d', [$this, 'UtIdToTag3d']),
            new \Twig_SimpleFilter('ut_tag_to_id', [$this, 'UtTagToId']),
            new \Twig_SimpleFilter('ut_tag_to_tag3d', [$this, 'UtTagToTag3d']),
            new \Twig_SimpleFilter('ut_tag3d_to_id', [$this, 'UtTag3dToId']),
            new \Twig_SimpleFilter('ut_tag3d_to_tag', [$this, 'UtTag3dToTag']),
        ];
    }

    /**
     * @param int $id
     *
     * @return string
     * @throws UnRecognisedTagException|\Exception|\Psr\Cache\InvalidArgumentException
     */
    public function UtIdToTag(int $id): string
    {
        return $this->worker->getTagGraphFromId($id);
    }

    /**
     * @param int $id
     *
     * @return string
     * @throws UnRecognisedTagException|\Exception|\Psr\Cache\InvalidArgumentException
     */
    public function UtIdToTag3d(int $id): string
    {
        return $this->worker->getTag3dFromId($id);
    }

    /**
     * @param string $tag
     *
     * @return int
     * @throws UnRecognisedTagException|\Exception|\Psr\Cache\InvalidArgumentException
     */
    public function UtTagToId(string $tag): int
    {
        return $this->worker->getIdFromTagGraph($tag);
    }

    /**
     * @param string $tag
     *
     * @return string
     * @throws UnRecognisedTagException|\Exception|\Psr\Cache\InvalidArgumentException
     */
    public function UtTagToTag3d(string $tag): string
    {
        return $this->worker->getTag3dFromTagGraph($tag);
    }

    /**
     * @param string $tag3d
     *
     * @return int
     * @throws UnRecognisedTagException|\Exception|\Psr\Cache\InvalidArgumentException
     */
    public function UtTag3dToId(string $tag3d): int
    {
        return $this->worker->getIdFromTag3d($tag3d);
    }

    /**
     * @param string $tag3d
     *
     * @return string
     * @throws UnRecognisedTagException|\Exception|\Psr\Cache\InvalidArgumentException
     */
    public function UtTag3dToTag(string $tag3d): string
    {
        return $this->worker->getTagGraphFromTag3d($tag3d);
    }
}
