<?php

use AlloCine\I18NBundle\Translation\Loco;
use AlloCine\UnifiedTag\Bundle\Worker\TranslationWorker;
use Symfony\Component\Finder\Finder;

define('API_KEY', 'p_Zvs_gZuY5P4wuEooAssIuGIslebk5zs');
require './vendor/autoload.php';

$client = new Loco(API_KEY);
$files = (new Finder())->sortByName()->in(TranslationWorker::OUTPUT_PATH)->name('*.xlf');

print_r("starting to import trads...\n");

/** @var SplFileInfo $file */
foreach ($files as $file) {
    print_r("importing {$file->getFilename()}...\n");
    preg_match('/^(.+?)\.(.+?)\.xlf$/', $file->getFilename(), $match);
    $tag = $match[1];
    $locale = $match[2];
    try {
        $client->import($file, $locale, $tag);
    } catch (\Exception $e) {
        print_r("error importing file {$file->getFilename()}: {$e->getMessage()}\n");
    }
}