<?php

declare(strict_types=1);

namespace AlloCine\UnifiedTag\Tests\Bundle\Cache;

use Exception;
use AlloCine\UnifiedTag\Bundle\Cache\UnifiedTagCacheWarmer;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Cache\Adapter\FilesystemAdapter;
use Symfony\Component\Cache\Adapter\PhpArrayAdapter;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Finder\Finder;

final class UnifiedTagCacheWarmerTest extends TestCase
{
    static public Filesystem $fs;

    static public array $testFiles = [];

    const string CSV_PATH = __DIR__.'/../../../src/Bundle/Resources/csv';
    const string TEST_PATH = __DIR__.'/../../var/tests';

    public static function setUpBeforeClass(): void
    {
        parent::setUpBeforeClass();

        static::$fs = new Filesystem();

        self::$testFiles = [
            'cache_file' => sprintf(
                '%s/../../var/cache/utb_cache_%s.php',
                __DIR__,
                uniqid('', true)
            )
        ];
    }

    public static function tearDownAfterClass(): void
    {
        parent::tearDownAfterClass();

        foreach (self::$testFiles as $file) {
            self::$fs->remove($file);
        }
    }

    public function testWarmUp(): void
    {
        $warmer = new UnifiedTagCacheWarmer(
            new PhpArrayAdapter(self::$testFiles['cache_file'], new FilesystemAdapter()),
            [self::CSV_PATH]
        );

        $warmer->warmUp('');
        $this->assertTrue(true);
    }

    public function testDuplicates(): void
    {
        $this->expectException(Exception::class);
        $duplicatedFile = self::TEST_PATH.'/activities.2.csv';
        self::$testFiles[] = $duplicatedFile;

        $finder = new Finder();

        foreach ($finder->in(self::CSV_PATH)->name('activities*')->files() as $file) {
            self::$fs->copy(
                $file->getFilename(),
                $duplicatedFile
            );
            break;
        }

        new UnifiedTagCacheWarmer(
            new PhpArrayAdapter(self::$testFiles['cache_file'], new FilesystemAdapter()),
            [self::CSV_PATH, self::TEST_PATH]
        );
    }
}
