<?php

declare(strict_types=1);

use Rector\Config\RectorConfig;
use Rector\Php81\Rector\ClassMethod\NewInInitializerRector;
use Rector\Php83\Rector\ClassMethod\AddOverrideAttributeToOverriddenMethodsRector;
use Rector\Set\ValueObject\LevelSetList;
use Rector\Set\ValueObject\SetList;
use Rector\ValueObject\PhpVersion;

return RectorConfig::configure()
    ->withPaths([
        __DIR__.'/src',
        __DIR__.'/tests',
        __DIR__.'/convert_mobile.php',
        __DIR__.'/export_trads.php',
        __DIR__.'/import_trads.php',
        __DIR__.'/update_trads.php',
    ])
    ->withPhpVersion(PhpVersion::PHP_84)
    ->withSets([
        SetList::PHP_84,
        LevelSetList::UP_TO_PHP_84,
        SetList::CODE_QUALITY,
        SetList::DEAD_CODE,
        SetList::RECTOR_PRESET,
        SetList::TYPE_DECLARATION,
    ])
    ->withRules([
        AddOverrideAttributeToOverriddenMethodsRector::class,
        NewInInitializerRector::class,
    ])
    ->withImportNames(removeUnusedImports: true)
    ->withComposerBased(symfony: true)
    ->withAttributesSets(symfony: true);
