import convert from 'xml-js'
import type { Element, ElementCompact } from 'xml-js'

type AbstractElement = Omit<Element | ElementCompact, 'elements' | 'name'>
type NodeElement = AbstractElement & {
	name: 'xliff' | 'file' | 'body'
	elements?: NodeElement[]
}
type RootElement = AbstractElement & {
	elements?: NodeElement[]
}

export const parseXliffString = (str: string) => {
	const index = new Map<string, string>()
	const parsed = convert.xml2js(str) as RootElement
	if (!parsed) throw new Error('Unable to decode file')

	const rootXliff = parsed.elements?.find(node => node.name === 'xliff')
	if (!rootXliff) throw new Error('Unable to retrieve root xliff node')

	const rootFile = rootXliff.elements?.find(node => node.name === 'file')
	if (!rootFile) throw new Error('Unable to retrieve root file node')

	const rootBody = rootFile.elements?.find(node => node.name === 'body')
	if (!rootBody) throw new Error('Unable to retrieve root body node for trans units')

	const transElements = rootBody.elements
	if (!(transElements instanceof Array && transElements.length > 0)) throw new Error('No trans units')

	for (const { elements, attributes } of transElements) {
		let key = attributes.resname
		if (!key) key = elements?.[0]?.elements?.[0]?.text
		const translation = elements?.[1]?.elements?.[0]?.text
		if (!(key && translation)) continue
		index.set(key, translation)
	}
	return index
}
