## —— Secret Manager 🔐️  ———————————————————————————————————————————————————————————————————————
fetch_secrets: gcloud_login gcloud_init ${SECRET_DEPENDENCIES} ## fetch dev secrets from secrets manager

fetch_file_secret: var-SECRET var-PROJECT var-OUTPUT_FILE ## fetch a single secret from secrets manager
	@$(call color_text,Fetching SECRET: ${SECRET} (${PROJECT}),33)
	@$(call color_text,Output file: ${OUTPUT_FILE},33)
	${GCLOUD_PREFIX} gcloud secrets versions access latest --secret="${SECRET}" --project=${PROJECT} --out-file=${OUTPUT_FILE}

.PHONY: refresh_secrets
refresh_secrets: clean_secrets fetch_secrets ## refresh dev secrets from secrets manager

.PHONY: clean_secrets
clean_secrets: ## clean local secret files
	rm -f ${SECRET_DEPENDENCIES}
