.PHONY: mkcert_install
mkcert_install: ## install mkcert
	@if ! which mkcert > /dev/null; then \
		OS_NAME=$$(uname -s); \
		if [ "$$OS_NAME" = "Darwin" ]; then \
			brew install mkcert; \
		else \
			OS_ID=$$(grep '^ID_LIKE=' /etc/os-release 2>/dev/null | cut -d'=' -f2 | tr -d '"'); \
			if [ -z "$$OS_ID" ]; then \
				OS_ID=$$(grep '^ID=' /etc/os-release 2>/dev/null | cut -d'=' -f2 | tr -d '"'); \
			fi; \
			if [ "$$OS_ID" = "arch" ]; then \
				sudo curl -sSL https://github.com/FiloSottile/mkcert/releases/download/v1.4.4/mkcert-v1.4.4-linux-amd64 -o /usr/local/bin/mkcert && sudo chmod +x /usr/local/bin/mkcert; \
				sudo pacman -Sy --noconfirm nss; \
			else \
				sudo curl -sSL https://github.com/FiloSottile/mkcert/releases/download/v1.4.4/mkcert-v1.4.4-linux-amd64 -o /usr/local/bin/mkcert && sudo chmod +x /usr/local/bin/mkcert; \
				sudo apt install libnss3-tools; \
			fi; \
		fi; \
	fi;

.PHONY: mkcert_init
mkcert_init: mkcert_install ## initialize mkcert and install the root certificate
	mkcert -install
