const convert = require('xml-js');

const parseXliffString = (str) => {
  const index = new Map();
  const parsed = convert.xml2js(str);
  if (!parsed) {
    throw new Error('Unable to decode file');
  }
  const rootXliff = parsed.elements ? parsed.elements.find(node => node.name === 'xliff') : undefined;
  if (!rootXliff) {
    throw new Error('Unable to retrieve root xliff node');
  }
  const rootFile = rootXliff.elements ? rootXliff.elements.find(node => node.name === 'file') : undefined;
  if (!rootFile) {
    throw new Error('Unable to retrieve root file node');
  }
  const rootBody = rootFile.elements ? rootFile.elements.find(node => node.name === 'body') : undefined;
  if (!rootBody) {
    throw new Error('Unable to retrieve root body node for trans units');
  }
  const transElements = rootBody.elements;
  if (!(transElements instanceof Array && transElements.length > 0)) {
    throw new Error('No trans units');
  }
  for (let i = 0; i < transElements.length; i++) {
    const transElement = transElements[i];
    const key = transElement.attributes.resname;
    const translation = transElement.elements
    && transElement.elements[1]
    && transElement.elements[1].elements
    && transElement.elements[1].elements[0] ?
      transElement.elements[1].elements[0].text : undefined;
    if (!(key && translation)) {
      continue;
    }
    index.set(key, transElement.elements[1].elements[0].text);
  }
  return index;
};

module.exports = {
  parseXliffString,
};
