<?php

namespace AlloCine\UnifiedTag\Tests\Bundle\Cache;

use AlloCine\UnifiedTag\Bundle\Cache\UnifiedTagCacheWarmer;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Cache\Adapter\FilesystemAdapter;
use Symfony\Component\Cache\Adapter\PhpArrayAdapter;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Finder\Finder;

class UnifiedTagCacheWarmerTest extends TestCase
{
    /**
     * @var Filesystem
     */
    static public $fs;

    static public $testFiles = [];

    const CSV_PATH = __DIR__.'/../../../src/Bundle/Resources/csv';
    const TEST_PATH = __DIR__.'/../../var/tests';

    public static function setUpBeforeClass()
    {
        parent::setUpBeforeClass();

        static::$fs = new Filesystem();

        self::$testFiles = [
            'cache_file' => sprintf(
                '%s/../../var/cache/utb_cache_%s.php',
                __DIR__,
                uniqid()
            )
        ];
    }

    public static function tearDownAfterClass()
    {
        parent::tearDownAfterClass();
        foreach (self::$testFiles as $file) {
            self::$fs->remove($file);
        }
    }

    public function testWarmUp()
    {
        $warmer = new UnifiedTagCacheWarmer(
            new PhpArrayAdapter(self::$testFiles['cache_file'], new FilesystemAdapter()),
            [self::CSV_PATH]
        );

        $warmer->warmUp(null);
        $this->assertTrue(true);
    }

    public function testDuplicates()
    {
        $this->expectException(\Exception::class);
        $duplicatedFile = self::TEST_PATH.'/activities.2.csv';
        self::$testFiles[] = $duplicatedFile;

        $finder = new Finder();
        foreach ($finder->in(self::CSV_PATH)->name('activities*')->files() as $file) {
            self::$fs->copy(
                $file,
                $duplicatedFile
            );
            break;
        }

        new UnifiedTagCacheWarmer(
            new PhpArrayAdapter(self::$testFiles['cache_file'], new FilesystemAdapter()),
            [self::CSV_PATH, self::TEST_PATH]
        );
    }
}
