<?php

namespace AlloCine\UnifiedTag\Bundle\Icu;

class IcuCompatibility
{
    const ICU_GENDERS = [
        0 => 'male',
        1 => 'female',
        2 => 'other',
    ];

    /**
     * Add a compatibility between the legacy gender format and the new ICU one.
     * Ex :
     * {0}Acteur|{1}Actrice
     * is now converted as :
     * {gender, select, male {Acteur} female {Actrice}}
     */
    public static function genderConversion(string $string): string
    {
        $regex = '#{\d}(\p{L}+)#u';

        if (\preg_match_all($regex, $string, $matches)) {
            $string = '{gender, select,';
            foreach ($matches[1] ?? [] as $key => $match) {
                if ($key <= \count(self::ICU_GENDERS)) {
                    $string .= ' '.self::ICU_GENDERS[$key].' {'.$match.'}';
                }
            }
            $string .= '}';
        }

        return $string;
    }
}
