<?php

namespace Allocine\TwigLinter\Reporter;

use Symfony\Component\Console\Output\OutputInterface;

class ConsoleReporter implements ReporterInterface
{
    /**
     * {@inheritdoc}
     */
    public function report(OutputInterface $output, array $violations)
    {
        $filename = null;

        foreach ($violations as $violation) {
            if ($filename != $violation->getFilename()) {
                $filename = $violation->getFilename();
                $output->writeln(sprintf('<comment>%s</comment>', $filename));
            }

            $output->writeln(sprintf(
                '<comment>l.%d c.%d</comment> : %s %s',
                $violation->getLine(),
                $violation->columnno,
                $violation->getSeverityAsString(),
                $violation->getReason()
            ));
        }

        if ($count = count($violations)) {
            $output->writeln(sprintf('<error>%d violations found</error>', $count));
        } else {
            $output->writeln('<info>No violation found.</info>');
        }
    }
}
