<?php

namespace AlloCine\SignUpValidatorBundle\Constraints;

/**
 * Your password must:
 *   - be at least 8 characters long
 *   - include both upper and lower case letters
 *   - include at least one number
 *   - contain at least one special character
 */
class Password extends CustomRegex
{
    /** @var string */
    public static $htmlPattern = '(?=.{8,})(?=.*[a-z])(?=.*[A-Z])(?=.*\d).*';
    /** @var string */
    public $pattern = '/(?=.{8,})(?=.*[a-z])(?=.*[A-Z])(?=.*\d).*/';
    /** @var string */
    public $message = 'Invalid Password';
}
