<?php

namespace AlloCine\SignUpValidatorBundle\Tests;

use AlloCine\SignUpValidatorBundle\Constraints\Email;
use Symfony\Bundle\FrameworkBundle\Test\KernelTestCase;

class EmailValidatorTest extends KernelTestCase
{
    private $container;

    public function setUp()
    {
        self::bootKernel();

        $this->container = self::$kernel->getContainer();
    }

    /**
     * @dataProvider emailProvider
     * @param $password
     * @param $isValid
     */
    public function testEmailValidation($email, $isValid, $checkMx)
    {
        $actual = (
            count($this->container->get('validator')->validate($email, new Email(['checkMX' => $checkMx]))) === 0
        );
        $this->assertEquals($isValid, $actual);
    }

    /**
     * @return array
     */
    public function emailProvider()
    {
        return [
            [' ', false, false],
            [null, false, false],
            ['', false, false],
            ['test', false, false],
            ['test@dsfdfdf.com', true, false],
            ['test@dsfdfdf.com', false, true],
            ['test@gmail.com', true, false],
            ['test@gmail.com', true, true],
        ];
    }
}
