<?php

namespace AlloCine\SignUpValidatorBundle\Constraints;

use Symfony\Component\Validator\Constraint;

/**
 * Email must be at format : x@x.x
 */
class Email extends Constraint
{
    /** @var string */
    public static $htmlPattern = '[^\.\s@:][^\s@:]*(?!\.)@[^\.\s@]+(?:\.[^\.\s@]+)*';
    /** @var string */
    public $pattern = '/[^\.\s@:][^\s@:]*(?!\.)@[^\.\s@]+(?:\.[^\.\s@]+)*/';
    /** @var bool */
    public $checkMX = false;
    /** @var string */
    public $message = 'Invalid Email';

    /**
     * {@inheritdoc}
     */
    public function validatedBy()
    {
        return EmailValidator::class;
    }
}
