<?php

namespace AlloCine\SignUpValidatorBundle\Tests;

use AlloCine\SignUpValidatorBundle\Constraints\Password;
use Symfony\Bundle\FrameworkBundle\Test\KernelTestCase;

class PasswordValidatorTest extends KernelTestCase
{
    private $container;

    public function setUp()
    {
        self::bootKernel();

        $this->container = self::$kernel->getContainer();
    }

    /**
     * @dataProvider passwordProvider
     * @param $password
     * @param $isValid
     */
    public function testPwdValidation($password, $isValid)
    {
        $actual = (count($this->container->get('validator')->validate($password, new Password())) === 0);
        $this->assertEquals($isValid, $actual);
    }

    /**
     * @return array
     */
    public function passwordProvider()
    {
        return [
            ['V@lid001'   , true ],
            ['dfPf-sp899' , true ],
            ['Valid001'   , true ],
            ['Valid01'    , false],
            ['12345678'   , false],
            ['abcdfegh'   , false],
            [' '          , false],
            [null         , false],
            [''           , false],
        ];
    }
}
