<?php

namespace AlloCine\SignUpValidatorBundle\Constraints;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

class EmailValidator extends ConstraintValidator
{
    /**
     * {@inheritdoc}
     */
    public function validate($value, Constraint $constraint)
    {
        if (!preg_match($constraint->pattern, $value)) {
            $this->context->buildViolation($constraint->message)->addViolation();

            return;
        }

        $host = (string) substr($value, strrpos($value, '@') + 1);

        // Check for host DNS resource records
        if ($constraint->checkMX) {
            if (!$this->checkMX($host)) {
                $this->context->buildViolation($constraint->message)->addViolation();
            }

            return;
        }
    }

    /**
     * Check DNS Records for MX type.
     * @param string $host
     * @return bool
     */
    private function checkMX(string $host)
    {
        return '' !== $host && checkdnsrr($host, 'MX');
    }
}
