<?php

namespace AlloCine\SignUpValidatorBundle\Tests\Fonctionnal;

use Composer\InstalledVersions;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Validator\Validation;
use Symfony\Component\Validator\Validator\ValidatorInterface;

class PasswordConstraintTest extends TestCase
{
    public function testAnnotationConstraint(): void
    {

        if (version_compare(InstalledVersions::getVersion('symfony/validator'), '7.0,0', '>=')) {
            static::assertTrue(true);
            return;
        }

        $user = new ClassTest();
        $user->passwordWithAnnotation = 'badPwd';

        $validator = Validation::createValidatorBuilder()
            ->enableAnnotationMapping()
            ->getValidator()
        ;

        $violations = $validator->validate($user);

        static::assertGreaterThan(0, $violations->count());
    }

    public function testAttributeConstraint(): void
    {
        if (version_compare(InstalledVersions::getVersion('symfony/validator'), '7.0,0', '<')) {
            static::assertTrue(true);
            return;
        }
        $user = new ClassTest();
        $user->passwordWithAttribute = 'badPwd';

        $validator = Validation::createValidatorBuilder()
            ->enableAttributeMapping()
            ->getValidator();

        $violations = $validator->validate($user);

        static::assertGreaterThan(0, $violations->count());
    }
}
