<?php

namespace AlloCine\SignUpValidatorBundle\Constraints;

use AlloCine\SignUpValidatorBundle\Constraints\Email;
use AlloCine\SignUpValidatorBundle\Constraints\Nickname;
use AlloCine\SignUpValidatorBundle\Constraints\Password;
use Symfony\Component\Validator\Constraints;
use Symfony\Component\Validator\Mapping\ClassMetadata;

class UserSignUpValidator
{
    private ?string $email;
    private ?string $password;
    private ?string $nickname;
    private ?string $ip;

    public function __construct(array $data)
    {
        $this->email = array_key_exists('email', $data) ? $data['email'] : null;
        $this->password = array_key_exists('password', $data) ? $data['password'] : null;
        $this->nickname = array_key_exists('nickname', $data) ? $data['nickname'] : null;
        $this->ip = array_key_exists('ip', $data) ? $data['ip'] : null;
    }


    public static function loadValidatorMetadata(ClassMetadata $metadata): void
    {
        $metadata->addPropertyConstraint('email', new Email(['checkMX' => true]));

        $metadata->addPropertyConstraint('password', new Password());

        $metadata->addPropertyConstraint('nickname', new Nickname());

        $metadata->addPropertyConstraints('ip', [
            new Constraints\NotBlank(),
            new Constraints\NotNull(),
            new Constraints\Ip(['version' => Constraints\Ip::ALL]),
        ]);
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function getPassword(): ?string
    {
        return $this->password;
    }

    public function getNickname(): ?string
    {
        return $this->nickname;
    }

    public function getIp(): ?string
    {
        return $this->ip;
    }
}
