<?php

namespace AlloCine\SignUpValidatorBundle\Constraints;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

class EmailValidator extends ConstraintValidator
{
    /**
     * {@inheritdoc}
     */
    public function validate($value, Constraint $constraint): void
    {
        if (!preg_match($constraint->pattern, $value)) {
            $this->context->buildViolation($constraint->message)->setCode(Email::INVALID_EMAIL)->addViolation();

            return;
        }

        $host = (string) substr($value, strrpos($value, '@') + 1);

        // Check for host DNS resource records
        if ($constraint->checkMX) {
            if (!$this->checkMX($host)) {
                $this->context->buildViolation($constraint->message)->setCode(Email::INVALID_EMAIL)->addViolation();
            }
        }
    }

    /**
     * Check DNS Records for MX type.
     */
    private function checkMX(string $host): bool
    {
        return '' !== $host && checkdnsrr($host, 'MX');
    }
}
