<?php

namespace AlloCine\SignUpValidatorBundle\Constraints;

use Symfony\Component\Validator\Constraint;

/**
 * Email must be at format : x@x.x
 *
 * @Annotation
 */
#[\Attribute]
class Email extends Constraint
{
    const INVALID_EMAIL = 'INVALID_EMAIL';

    public static string $htmlPattern = '^\S+\@\S+\.\S+$';
    public string $pattern = '/^\S+\@\S+\.\S+$/';
    public bool $checkMX = false;
    public string $message = 'Invalid Email';

    /**
     * {@inheritdoc}
     */
    public function validatedBy(): string
    {
        return EmailValidator::class;
    }
}
