<?php

namespace AlloCine\SignUpValidatorBundle\Tests;

use AlloCine\SignUpValidatorBundle\Constraints\UserSignUpValidator;
use Symfony\Bundle\FrameworkBundle\Test\KernelTestCase;

class UserSignUpValidatorTest extends KernelTestCase
{
    private $container;

    public function setUp()
    {
        self::bootKernel();

        $this->container = self::$kernel->getContainer();
    }

    /**
     * @dataProvider dataProvider
     * @param $password
     * @param $isValid
     */
    public function testUserSignUpValidation($webUserData, $isValid)
    {
        $actual = (count($this->container->get('validator')->validate(new UserSignUpValidator($webUserData))) === 0);
        $this->assertEquals($isValid, $actual);
    }

    /**
     * @return array
     */
    public function dataProvider()
    {
        return [
            [
                [
                    'email' => 'example@yopmail.com',
                    'password' => 'wAlid@1drt',
                    'nickname' => 'pseudo',
                    'ip' => '1.2.3.4'
                ],
                true
            ],
            [
                ['email' => 'example@qsdqs.com', 'password' => 'wAlid@1drt', 'nickname' => 'pseudo', 'ip' => '1.2.3.4'],
                false
            ],
            [
                [
                    'email' => 'example@yopmail.com',
                    'password' => 'wAlid@1drt',
                    'nickname' => 'pseudo',
                    'ip' => '1.2.3.400'
                ],
                false
            ],
            [
                [
                    'email' => 'exampleyopmail.com',
                    'password' => 'wAlid@1drt',
                    'nickname' => 'pseudo',
                    'ip' => '1.2.3.4'
                ],
                false
            ],
            [
                ['email' => '', 'password' => 'wAlid@1drt', 'nickname' => 'pseudo', 'ip' => '1.2.3.4'],
                false
            ],
            [
                ['email' => 'exampleyopmail.com', 'password' => '', 'nickname' => 'pseudo', 'ip' => '1.2.3.4'],
                false
            ],
            [
                ['email' => 'exampleyopmail.com', 'password' => 'wAlid1drt', 'nickname' => 'pseudo', 'ip' => '1.2.3.4'],
                false
            ],
            [
                ['email' => 'exampleyopmail.com', 'password' => 'wAlid@1drt', 'nickname' => '', 'ip' => '1.2.3.4'],
                false
            ],
            [
                ['email' => 'exampleyopmail.com', 'password' => 'wAlid@1drt', 'nickname' => '', 'ip' => '1.2.3.4'],
                false
            ],
            [
                ['email' => 'exampleyopmail.com', 'password' => 'wAlid@1drt', 'nickname' => 'ps', 'ip' => '1.2.3.4'],
                false
            ],
            [
                ['email' => 'exampleyopmail.com', 'password' => 'wAlid@1drt', 'nickname' => 'pseudo', 'ip' => ''],
                false
            ],
        ];
    }
}
