<?php

namespace AlloCine\SignUpValidatorBundle\Tests\Constraints;

use AlloCine\SignUpValidatorBundle\Constraints\UserSignUpValidator;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Validator\Validation;


class UserSignUpValidatorTest extends TestCase
{
    /**
     * @dataProvider dataProvider
     */
    public function testUserSignUpValidation($webUserData, $isValid): void
    {
        $validator = Validation::createValidatorBuilder()
            ->addMethodMapping('loadValidatorMetadata')
            ->getValidator();
        $errors = $validator->validate(new UserSignUpValidator($webUserData));
        $actual = count($errors) === 0;
        $this->assertEquals($isValid, $actual);
    }

    public function dataProvider(): array
    {
        return [
            [
                [
                    'email' => 'example@yopmail.com',
                    'password' => 'wAlid@1drt',
                    'nickname' => 'pseudo',
                    'ip' => '1.2.3.4'
                ],
                true
            ],
            [
                ['email' => 'example@amxdomainthatcannotexists.com', 'password' => 'wAlid@1drt', 'nickname' => 'pseudo', 'ip' => '1.2.3.4'],
                false
            ],
            [
                [
                    'email' => 'example@yopmail.com',
                    'password' => 'wAlid@1drt',
                    'nickname' => 'pseudo',
                    'ip' => '1.2.3.400'
                ],
                false
            ],
            [
                [
                    'email' => 'exampleyopmail.com',
                    'password' => 'wAlid@1drt',
                    'nickname' => 'pseudo',
                    'ip' => '1.2.3.4'
                ],
                false
            ],
            [
                ['email' => '', 'password' => 'wAlid@1drt', 'nickname' => 'pseudo', 'ip' => '1.2.3.4'],
                false
            ],
            [
                ['email' => 'exampleyopmail.com', 'password' => '', 'nickname' => 'pseudo', 'ip' => '1.2.3.4'],
                false
            ],
            [
                ['email' => 'exampleyopmail.com', 'password' => 'wAlid1drt', 'nickname' => 'pseudo', 'ip' => '1.2.3.4'],
                false
            ],
            [
                ['email' => 'exampleyopmail.com', 'password' => 'wAlid@1drt', 'nickname' => '', 'ip' => '1.2.3.4'],
                false
            ],
            [
                ['email' => 'exampleyopmail.com', 'password' => 'wAlid@1drt', 'nickname' => '', 'ip' => '1.2.3.4'],
                false
            ],
            [
                ['email' => 'exampleyopmail.com', 'password' => 'wAlid@1drt', 'nickname' => 'ps', 'ip' => '1.2.3.4'],
                false
            ],
            [
                ['email' => 'exampleyopmail.com', 'password' => 'wAlid@1drt', 'nickname' => 'pseudo', 'ip' => ''],
                false
            ],
        ];
    }
}
