<?php

namespace AlloCine\SignUpValidatorBundle\Tests\Constraints;

use AlloCine\SignUpValidatorBundle\Constraints\Password;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Validator\Validation;

class PasswordValidatorTest extends TestCase
{
    /**
     * @dataProvider passwordProvider
     */
    public function testPwdValidation(?string $password, bool $isValid)
    {
        $actual = (count(Validation::createValidatorBuilder()->getValidator()->validate($password, new Password())) === 0);
        $this->assertEquals($isValid, $actual);
    }

    public function passwordProvider(): array
    {
        return [
            ['V@lid001'                 , true ],
            ['dfPf-sp899'               , true ],
            ['Valid001'                 , true ],
            ['Valid01'                  , false],
            ['12345678'                 , false],
            ['abcdfegh'                 , false],
            [' '                        , false],
            [null                       , false],
            [''                         , false],
            [str_repeat('V@ld1', 20)    , true ],
            [str_repeat('V@ld1', 20).'e', false],
        ];
    }
}
