<?php

namespace AlloCine\SignUpValidatorBundle\Tests\Constraints;

use AlloCine\SignUpValidatorBundle\Constraints\Email;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Validator\Validation;

class EmailValidatorTest extends TestCase
{
    /**
     * @dataProvider emailProvider
     */
    public function testEmailValidation(string $email, bool $isValid, bool $checkMx): void
    {
        $actual = Validation::createValidatorBuilder()->getValidator()->validate($email, new Email(checkMX : $checkMx));
        static::assertSame($isValid, count($actual) === 0);
    }

    public function emailProvider(): array
    {
        return [
            [' ', false, false],
            ['', false, false],
            ['test', false, false],
            ['test@amxdomainthatcannotexists.com', true, false],
            ['test@amxdomainthatcannotexists.com', false, true],
            ['test@gmail.com', true, false],
            ['abc def@yahoo.fr', false, false],
            ['abc def@yahoo .fr', false, false],
            ['abcdef@yahoo.fr ', false, false],
            ['abcdef@yahoo.fr', true, true],
            ['test@gmail.com', true, true],
        ];
    }
}
