<?php

namespace AlloCine\SignUpValidatorBundle\Constraints;

/**
 * Your password must:
 *   - be at least 8 characters long
 *   - include both upper and lower case letters
 *   - include at least one number
 *   - contain at least one special character
 *
 * @Annotation
 */
#[\Attribute]
class Password extends CustomRegex
{
    public static string $htmlPattern = '^(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[a-zA-Z]).{8,100}$';
    public string $pattern = '/^(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[a-zA-Z]).{8,100}$/';
    public string $message = 'Invalid Password';
}
