<?php

namespace AlloCine\SignUpValidatorBundle\Constraints;

use Symfony\Component\Validator\Attribute\HasNamedArguments;
use Symfony\Component\Validator\Constraint;

/**
 * Email must be at format : x@x.x
 *
 * @Annotation
 */
#[\Attribute]
class Email extends Constraint
{
    const INVALID_EMAIL = 'INVALID_EMAIL';

    public static string $htmlPattern = '^\S+\@\S+\.\S+$';
    public string $pattern = '/^\S+\@\S+\.\S+$/';
    public bool $checkMX = false;
    public string $message = 'Invalid Email';
    
    /**
     * Allow attribute-style named arguments like #[Email(checkMX: true)]
     * or classic usage: new Email(['checkMX' => true]).
     *
     * The constructor merges provided explicit args into the options
     * array forwarded to the base Constraint constructor.
     */
    #[HasNamedArguments]
    public function __construct(
        bool $checkMX = false,
        ?string $pattern = null,
        ?string $message = null,
        $options = null,
        ?array $groups = null,
        $payload = null
    )
    {
        // Merge named arguments into options array in a backward-compatible way
        if (is_array($options)) {
            $options = array_merge(['checkMX' => $checkMX], $options);
        } else {
            $options = ['checkMX' => $checkMX];
        }

        if (null !== $pattern) {
            $options['pattern'] = $pattern;
        }

        if (null !== $message) {
            $options['message'] = $message;
        }

        parent::__construct($options, $groups, $payload);
    }
    
    /**
     * {@inheritdoc}
     */
    public function validatedBy(): string
    {
        return EmailValidator::class;
    }
}
