<?php

namespace AlloCine\SignUpValidatorBundle\Constraints;

use Symfony\Component\Validator\Attribute\HasNamedArguments;
use Symfony\Component\Validator\Constraint;

/**
 * @Annotation
 */
#[\Attribute]
class CustomRegex extends Constraint
{
    /**
     * {@inheritdoc}
     */
    public function getRequiredOptions(): array
    {
        return [];
    }

    #[HasNamedArguments]
    public function __construct(
        public bool $match = true,
        ?array $groups = null,
        mixed $payload = null
    )
    {
        $this->match = $match;
        parent::__construct([], $groups, $payload);
    }

    /**
     * {@inheritdoc}
     */
    public function validatedBy(): string
    {
        return CustomRegexValidator::class;
    }
}
