<?php

namespace AlloCine\SignUpValidatorBundle\Tests;

use AlloCine\SignUpValidatorBundle\Constraints\Nickname;
use Symfony\Bundle\FrameworkBundle\Test\KernelTestCase;

class NicknameValidatorTest extends KernelTestCase
{
    private $container;

    public function setUp()
    {
        self::bootKernel();

        $this->container = self::$kernel->getContainer();
    }

    /**
     * @dataProvider nicknameProvider
     * @param $password
     * @param $isValid
     */
    public function testNicknameValidation($nickname, $isValid)
    {
        $actual = (count($this->container->get('validator')->validate($nickname, new Nickname())) === 0);
        $this->assertEquals($isValid, $actual);
    }

    /**
     * @return array
     */
    public function nicknameProvider()
    {
        return [
            ['V@lid001'   , true ],
            ['dfPf-sp899' , true ],
            ['Valid001'   , true ],
            ['Valid01'    , true ],
            ['12345678'   , true ],
            ['abcdfegh'   , true ],
            ['ab'         , false],
            [' '          , false],
            [null         , false],
            [''           , false],
        ];
    }
}
