<?php

namespace AlloCine\SignUpValidatorBundle\DependencyInjection;

use AlloCine\SignUpValidatorBundle\Constraints\Email;
use AlloCine\SignUpValidatorBundle\Constraints\Nickname;
use AlloCine\SignUpValidatorBundle\Constraints\Password;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;

class AlloCineSignUpValidatorExtension extends Extension implements PrependExtensionInterface
{
    /**
     * @inheritdoc
     */
    public function prepend(ContainerBuilder $container)
    {
        $container->setParameter('sign_up_email_regex', Email::$htmlPattern);
        $container->setParameter('sign_up_password_regex', Password::$htmlPattern);
        $container->setParameter('sign_up_nickname_regex', Nickname::$htmlPattern);
    }

    /**
     * @inheritdoc
     */
    public function load(array $configs, ContainerBuilder $container)
    {
    }
}
