<?php

namespace AlloCine\SignUpValidatorBundle\Constraints;

use AlloCine\SignUpValidatorBundle\Constraints\Email;
use AlloCine\SignUpValidatorBundle\Constraints\Nickname;
use AlloCine\SignUpValidatorBundle\Constraints\Password;
use Symfony\Component\Validator\Constraints;
use Symfony\Component\Validator\Mapping\ClassMetadata;

class UserSignUpValidator
{
    /** @var string|null */
    private $email;
    /** @var string|null */
    private $password;
    /** @var string|null */
    private $nickname;
    /** @var string|null */
    private $ip;

    /**
     * UserSignUp constructor.
     * @param array $data
     */
    public function __construct(array $data)
    {
        $this->email = array_key_exists('email', $data) ? $data['email'] : null;
        $this->password = array_key_exists('password', $data) ? $data['password'] : null;
        $this->nickname = array_key_exists('nickname', $data) ? $data['nickname'] : null;
        $this->ip = array_key_exists('ip', $data) ? $data['ip'] : null;
    }

    /**
     * @param ClassMetadata $metadata
     */
    public static function loadValidatorMetadata(ClassMetadata $metadata)
    {
        $metadata->addPropertyConstraint('email', new Email(['checkMX' => true]));

        $metadata->addPropertyConstraint('password', new Password());

        $metadata->addPropertyConstraint('nickname', new Nickname());

        $metadata->addPropertyConstraints('ip', [
            new Constraints\NotBlank(),
            new Constraints\NotNull(),
            new Constraints\Ip(['version' => Constraints\Ip::ALL]),
        ]);
    }

    /**
     * @return null|string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @return null|string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @return null|string
     */
    public function getNickname()
    {
        return $this->nickname;
    }

    /**
     * @return null|string
     */
    public function getIp()
    {
        return $this->ip;
    }
}
