<?php

namespace AlloCine\SignUpValidatorBundle\Tests\Constraints;

use AlloCine\SignUpValidatorBundle\Constraints\Nickname;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Validator\Validation;

class NicknameValidatorTest extends TestCase
{
    /**
     * @dataProvider nicknameProvider
     * @param $password
     * @param $isValid
     */
    public function testNicknameValidation($nickname, $isValid)
    {
        $actual = (count(Validation::createValidatorBuilder()->getValidator()->validate($nickname, new Nickname())) === 0);
        $this->assertEquals($isValid, $actual);
    }

    /**
     * @return array
     */
    public function nicknameProvider()
    {
        return [
            ['V@lid001'   , true ],
            ['dfPf-sp899' , true ],
            ['Valid001'   , true ],
            ['Valid01'    , true ],
            ['12345678'   , true ],
            ['abcdfegh'   , true ],
            ['ab'         , false],
            [' '          , false],
            [null         , false],
            [''           , false],
            ['abcdfeghabcdfeghabcdfeghabcdfeghabcd
            feghabcdfeghabcdfeghabcdfeghabcdfeghab
            cdfeghabcdfeghabcdfeghaa101', false],
            ['va@léè', true],
            ['pseudo avec exactement 100 caractères abcdefghijklmnopqurstuvwxyz abcdefghijklmnopqurstuvwxyz 123456', true],
        ];
    }
}
