<?php

namespace AlloCine\SignUpValidatorBundle\Constraints;

/**
 * Your password must:
 *   - be at least 8 characters long
 *   - include both upper and lower case letters
 *   - include at least one number
 *   - contain at least one special character
 *
 * @Annotation
 */
class Password extends CustomRegex
{
    /** @var string */
    public static $htmlPattern = '^(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[a-zA-Z]).{8,100}$';
    /** @var string */
    public $pattern = '/^(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[a-zA-Z]).{8,100}$/';
    /** @var string */
    public $message = 'Invalid Password';
}
