<?php

namespace AlloCine\SignUpValidatorBundle\Tests;

use AlloCine\SignUpValidatorBundle\Constraints\Email;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Validator\Validation;

class EmailValidatorTest extends TestCase
{
    /**
     * @dataProvider emailProvider
     * @param $password
     * @param $isValid
     */
    public function testEmailValidation($email, $isValid, $checkMx)
    {
        $actual = count(Validation::createValidatorBuilder()->getValidator()->validate($email, new Email(['checkMX' => $checkMx]))) === 0;
        $this->assertEquals($isValid, $actual);
    }

    /**
     * @return array
     */
    public function emailProvider()
    {
        return [
            [' ', false, false],
            [null, false, false],
            ['', false, false],
            ['test', false, false],
            ['test@amxdomainthatcannotexists.com', true, false],
            ['test@amxdomainthatcannotexists.com', false, true],
            ['test@gmail.com', true, false],
            ['test@gmail.com', true, true],
        ];
    }
}
