<?php

namespace AlloCine\SecureApiBundle\DependencyInjection;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;

/**
 * This is the class that loads and manages your bundle configuration
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/extension.html}
 */
class AlloCineSecureApiExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader =
            new Loader\YamlFileLoader(
                $container,
                new FileLocator(__DIR__.'/../Resources/config')
            );
        $loader->load('services.yml');

        if ($config['profiler']) {
            $container->getDefinition('allocine.api.middleware.cache')->addArgument(true);
        }

        if (!$config['cache']['enabled'] || is_null($container->getParameter('redis_host'))) {
            $container->removeDefinition('allocine.api.cache');
            $container->removeDefinition('allocine.api.cache.redis');
            $container->register(
                'allocine.api.cache',
                \Doctrine\Common\Cache\FilesystemCache::class
            )->addArgument("%kernel.cache_dir%/partner");
        } else {
            $container->getDefinition('allocine.api.cache_adapter')->replaceArgument(1, $config['cache']['ttl']);
        }
    }

    /**
     * {@inheritdoc}
     */
    public function getAlias()
    {
        return 'allocine_api';
    }
}
