<?php

namespace AlloCine\SecureApiBundle\Api\Social;

use AlloCine\SecureApiBundle\Api\Base\AbstractApi;
use AlloCine\SecureApiBundle\QueryBuilder\ReviewQueryBuilder;

class ReviewApi extends AbstractApi
{
    const FILTER_PRESS = 'press';
    const FILTER_PUBLIC = 'public';

    const SUBJECT_MOVIE = 'movie';
    const SUBJECT_SERIES = 'series';

    const ORDER_TYPE_HELPFULL = 'helpful';
    const ORDER_TYPE_RATING = 'rating';

    const ORDER_ASC = 'asc';
    const ORDER_DESC = 'desc';

    const RATING_FILTER_MOBILE = 'mobile';
    const RATING_FILTER_WEB = 'web';

    /**
     * @return ReviewQueryBuilder
     */
    public function createQuery()
    {
        return new ReviewQueryBuilder($this);
    }

    /**
     * @param mixed[] $query
     *
     * @return mixed
     */
    public function executeFromBuilder(array $query)
    {
        return $this->fetch('reviewlist', $query);
    }

    /**
     * @param $filter
     * @param $subjectType
     * @param $subjectId
     * @param $orderType
     * @param $orderDirection
     * @param int $offset
     * @param int $limit
     *
     * @return mixed
     */
    public function getReviews(
        $filter,
        $subjectType,
        $subjectId,
        $orderType,
        $orderDirection,
        $offset,
        $limit = 10
    ) {
        return $this->fetch('reviewlist', [
            'filter' => $filter,
            'subject' => "$subjectType:$subjectId",
            'order' => "$orderType$orderDirection",
            'page' => (intval($offset / $limit) + 1),
            'count' => $limit
        ]);
    }

    /**
     * @param $filter
     * @param $subjectType
     * @param $subjectId
     *
     * @return array
     */
    public function getReviewCountByRating(
        $filter,
        $subjectType,
        $subjectId
    ) {
        $r = [];

        foreach (range(1, 5) as $rating) {
            $r[$rating] = $this->fetch('reviewlist', [
                'filter' => $filter,
                'subject' => "$subjectType:$subjectId",
                'rating' => $rating,
                'page' => 1,
                'count' => 0
            ])->feed->totalResults;
        }

        return $r;
    }


    /**
     * @param $filter
     * @param $subjectType
     * @param $subjectId
     *
     * @return int
     */
    public function getReviewCount(
        $filter,
        $subjectType,
        $subjectId
    ) {
        return $this->fetch('reviewlist', [
            'filter' => $filter,
            'subject' => "$subjectType:$subjectId",
            'page' => 1,
            'count' => 0
        ])->feed->totalResults;
    }

    /**
     * @param int $id
     * @param string $profile
     *
     * @return mixed
     */
    public function getMovieReviewsDetail(int $id, $profile = 'medium')
    {
        return $this->fetch('movie', [
            'profile' => $profile,
            'code' => $id
        ]);
    }

    /**
     * @param int $id
     * @param int|null $seasonId
     * @param int|null $episodeId
     * @param string $profile
     *
     * @return mixed
     */
    public function getSeriesReviewsDetail(int $id, $seasonId = null, $episodeId = null, $profile = 'medium')
    {
        return $this->fetch('series', [
            'profile' => $profile,
            'code' => $id,
            'seasonId' => $seasonId,
            'episodeId' => $episodeId
        ]);
    }
}
