<?php

namespace AlloCine\SecureApiBundle\Tests\Api;

use AlloCine\SecureApiBundle\Api\Base\AbstractApi;
use AlloCine\SecureApiBundle\Api\Base\ApiDecoder;
use GuzzleHttp\Psr7\Response;

class AbstractApiTestCase extends \PHPUnit_Framework_TestCase
{
    /**
     * @param string     $class
     * @param string     $result
     * @param stringnull $pathExpectations
     * @param mixed|null $expectations
     *
     * @return AbstractApi
     */
    protected function getApi($class, $result, $pathExpectations = null, $expectations = null)
    {
        $client = $this
            ->getMockBuilder('AlloCine\SecureApiBundle\Client\MultiRegionApiClient')
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $method = $client
            ->expects($this->once())
            ->method('get')
            ->willReturn(new Response(200, [], $result))
        ;

        if ($pathExpectations && $expectations) {
            $method->with($pathExpectations, $expectations);
        }

        return new $class($client, new ApiDecoder());
    }
}
