<?php

namespace AlloCine\SecureApiBundle\Api\Wrapper;

use AlloCine\SecureApiBundle\Api\Standard\ShowtimeApi;
use AlloCine\SecureApiBundle\Api\Standard\ShowtimeDaysApi;
use AlloCine\SecureApiBundle\Api\Standard\TheaterApi;

/**
 * Class ApiWrapper
 * @package AlloCine\SecureApiBundle\Api
 */
class ApiWrapper
{
    /**
     * ShowtimeApi $showtimeApi
     */
    private $showtimeApi;

    /**
     * @var TheaterApi
     */
    private $theaterApi;

    /**
     * @param ShowtimeApi $showtimeApi
     * @param ShowtimeDaysApi $showtimeDaysApi
     * @param TheaterApi $theaterApi
     */
    public function __construct(
        ShowtimeApi $showtimeApi,
        ShowtimeDaysApi $showtimeDaysApi,
        TheaterApi $theaterApi
    ) {
        $this->showtimeApi = $showtimeApi;
        $this->showtimeDaysApi = $showtimeDaysApi;
        $this->theaterApi = $theaterApi;
    }

    /**
     * @return ShowtimeApi
     */
    public function showtime()
    {
        return $this->showtimeApi;
    }

    /**
     * @return ShowtimeDaysApi
     */
    public function showtimeDays()
    {
        return $this->showtimeDaysApi;
    }

    /**
     * @return TheaterApi
     */
    public function theater()
    {
        return $this->theaterApi;
    }
}
