<?php

namespace AlloCine\SecureApiBundle\DependencyInjection\CompilerPass;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

class CollectorPass implements CompilerPassInterface
{
    const COLLECTOR_TAG = 'allocine.api.client.collector';

    /**
     * @param ContainerBuilder $container
     */
    public function process(ContainerBuilder $container)
    {
        $services = $container->findTaggedServiceIds(self::COLLECTOR_TAG);

        foreach ($services as $id => $tags) {
            $definition = $container->findDefinition($id);
            $definition->addMethodCall('setCollector', [new Reference('csa_guzzle.data_collector.history_bag')]);
        }
    }
}
