<?php

namespace AlloCine\SecureApiBundle\QueryBuilder;

use AlloCine\SecureApiBundle\Api\Standard\ShowtimeDaysApi;

class ShowtimeDaysQueryBuilder
{
    const API_MAX_INT = 2147483646;
    const DEFAULT_COUNT = 10;

    /**
     * @var ReviewApi
     */
    private $api;

    /**
     * @var callable
     */
    private $callback;

    /**
     * @var float
     */
    private $lat;

    /**
     * @var float
     */
    private $long;

    /**
     * @var string
     */
    private $location;

    /**
     * @var integer
     */
    private $movie;

    /**
     * @var string[]
     */
    private $theaters;

    /**
     * @var integer
     */
    private $zip;

    /**
     * @var integer
     */
    private $count;

    /**
     * @param ShowtimeApi $api
     */
    public function __construct(ShowtimeDaysApi $api)
    {
        $this->api = $api;
        $this->theaters = [];
        $this->count = self::DEFAULT_COUNT;
    }

    /**
     * @param float $lat
     * @param float $long
     *
     * @return ShowtimeQueryBuilder
     */
    public function setGeo($lat, $long)
    {
        $this->lat  = $lat;
        $this->long = $long;

        return $this;
    }

    /**
     * @param string $location
     *
     * @return ShowtimeQueryBuilder
     */
    public function setLocation($location)
    {
        $this->location = $location;

        return $this;
    }

    /**
     * @param integer $movie
     *
     * @return ShowtimeQueryBuilder
     */
    public function setMovie($movie)
    {
        $this->movie = $movie;

        return $this;
    }

    /**
     * @param string[] $theaters
     *
     * @return ShowtimeQueryBuilder
     */
    public function setTheaters(array $theaters)
    {
        $this->theaters = $theaters;

        return $this;
    }

    /**
     * @param integer $zip
     *
     * @return ShowtimeQueryBuilder
     */
    public function setZip($zip)
    {
        $this->zip = $zip;

        return $this;
    }

    /**
     * If provided, the execute method will call this before
     * returning the api call.
     *
     * @param callable $callback
     *
     * @return ReviewQueryBuilder
     */
    public function callback(callable $callback)
    {
        $this->callback = $callback;

        return $this;
    }

    /**
     * @param integer $count
     */
    public function setCount($count)
    {
        $this->count = $count;

        return $this;
    }

    /**
     * @return mixed|null
     */
    public function execute()
    {
        $theaters = count($this->theaters) ? implode(',', $this->theaters) : null;

        $result = $this->api->executeFromBuilder([
            'lat' => $this->lat,
            'long' => $this->long,
            'location' => $this->location,
            'movie' => $this->movie,
            'theaters' => $theaters,
            'zip' => $this->zip,
            'count' => $this->count
        ]);

        if ($this->callback) {
            $result = call_user_func($this->callback, $result);
        }

        return $result;
    }
}
