<?php

namespace AlloCine\SecureApiBundle\Tests\QueryBuilder;

use AlloCine\SecureApiBundle\Api\Standard\ShowtimeDaysApi;
use AlloCine\SecureApiBundle\QueryBuilder\ShowtimeDaysQueryBuilder;

class ShowtimeDaysQueryBuilderTest extends \PHPUnit_Framework_TestCase
{
    public function testNominalCase()
    {
        $mock = $this->getShowtimeDaysApiMock([
            'lat' => 1.22,
            'long' => 1.33,
            'location' => 'Toulouse',
            'movie' => 1,
            'theaters' => 'P001,P002',
            'zip' => 31000,
        ]);

        $builder = new ShowtimeDaysQueryBuilder($mock);
        $builder
            ->setGeo(1.22, 1.33)
            ->setLocation('Toulouse')
            ->setMovie(1)
            ->setTheaters(['P001', 'P002'])
            ->setZip(31000)
            ->execute()
        ;
    }

    public function testPageOverflow()
    {
        $mock = $this->getShowtimeDaysApiMock([
            'lat'          => null,
            'long'         => null,
            'location'     => null,
            'movie'        => null,
            'theaters'     => null,
            'zip'          => null
        ]);

        $builder = new ShowtimeDaysQueryBuilder($mock);
        $builder->execute();
    }

    public function testNegativePage()
    {
        $mock = $this->getShowtimeDaysApiMock([
            'lat'  => null,
            'long' => null,
            'location' => null,
            'movie' => null,
            'theaters' => null,
            'zip' => null,
        ]);

        $builder = new ShowtimeDaysQueryBuilder($mock);
        $builder->execute();
    }

    public function testCallback()
    {
        $mock = $this->getShowtimeDaysApiMock();
        $mock
            ->expects($this->once())
            ->method('executeFromBuilder')
            ->willReturn(new \stdClass)
        ;

        $passed = false;

        $builder = new ShowtimeDaysQueryBuilder($mock);
        $builder->callback(function ($result) use (&$passed) {
            $passed = true;
            $this->assertEquals(new \stdClass, $result);
        });
        $builder->execute();

        $this->assertTrue($passed);
    }

    /**
     * @param null|array $expectedValues
     *
     * @return ShowtimeDaysApi A mocked version of ShowtimeA pi
     */
    public function getShowtimeDaysApiMock($expectedValues = null)
    {
        $mock = $this
            ->getMockBuilder('AlloCine\SecureApiBundle\Api\Standard\ShowtimeDaysApi')
            ->disableOriginalConstructor()
            ->getMock()
        ;

        if ($expectedValues) {
            $mock
                ->expects($this->once())
                ->method('executeFromBuilder')
                ->with($expectedValues)
                ->willReturn(new \stdClass)
            ;
        }

        return $mock;
    }
}
